       PROGRAM COFNON 
C 
        PARAMETER (A=70.,PI=3.141592653,W=2.*PI, 
     1          N=400,DT=0.01,KMAX=500, 
     2          N1=N-1,N10=N-10,AM=10.) 
C 
        REAL G(0:N),Q(0:N),Y(0:N),V(0:N),C(0:N),R(0:N), 
     1          M(0:N,4),AA(0:N),HH(0:N),X(0:N), 
     2          V1(0:N),V2(0:N) 
C 
        DATA T/0./,C(0)/20000./,KPRINT/100/ 
C 
        GG(CC,YY,RR,VV)=RR*(VV**3-VV)+CC*YY 
C 
C*************MAIN PROGRAM (LABEL 1-9)******************** 
c 
        open (0,FILE=':UDD:COCH:DATA:DATA1_02_04') 
        H=1./FLOAT(N) 
        E1=EXP(-5.25*H) 
        E2=E1*E1 
        R(0)=5.*SQRT(2.) 
        A2=(A*H)**2 
 
        AA(0)=2.+A2 
        AA(1)=-AA(0)+2./AA(0) 
        DO 1 I=2,N1 
 1      AA(I)=-AA(0)-1./AA(I-1) 
        DO 2 I=1,N 
        C(I)=C(I-1)*E2 
 2      R(I)=R(I-1)*E1 
 
        DO 3 I=0,N 
        G(I)=0. 
        Y(I)=0.01*SIN(20.*PI*(I*H-1.)) 
 3      V(I)=0.01*COS(20.*PI*(I*H-1.)) 
     1          *(1.-(I*H)**2) 
 
C***************RK4 LOOP (LABEL 10-29)*********************** 
C 
        DO 10 K=1,KMAX 
        F0=F(T,AM,W) 
        DO 11 I=0,N1 
 11     G(I)=GG(C(I),Y(I),R(I),V(I)) 
        KR=1 
        GOTO 30 
C 
 16     F0=F(T+DT/2.,AM,W) 
        DO 12 I=0,N1 
        V1(I)=V(I)+M(I,1)/2. 
 12     G(I)=GG(C(I),Y(I)+V(I)*DT/2.,R(I),V1(I)) 
        KR=2 
        GOTO 30 
C 
 17     DO 13 I=0,N1 
        V2(I)=V(I)+M(I,2)/2. 
 13     G(I)=GG(C(I),Y(I)+DT/2.*V1(I),R(I),V2(I)) 
        KR=3 
        GOTO 30 
C 
 18     F0=F(T+DT,AM,W) 
        DO 14 I=0,N1 
 14     G(I)=GG(C(I),Y(I)+DT*V2(I),R(I),V(I)+M(I,3)) 
        KR=4 
        GOTO 30 
C 
 19     DO 15 I=0,N1 
        Y(I)=Y(I)+DT*(V(I)+(M(I,1)+M(I,2)+M(I,3))/6.) 
 15     V(I)=V(I)+(M(I,1)+2.*(M(I,2)+M(I,3))+M(I,4))/6. 
        T=T+DT 
        GOTO 20 
C 
C***********GAUSS ELIMINATION (LABEL 30-39)*********** 
C 
 30     HH(0)=A2*G(0)-2.*H*F0 
        DO 31 I=1,N1 
 31     HH(I)=-A2*G(I)-HH(I-1)/AA(I-1) 
        Q(N1)=HH(N1)/AA(N1) 
        DO 32 I=2,N1 
        J=N-I 
 32     Q(J)=(HH(J)-Q(J+1))/AA(J) 
        Q(0)=(2.*Q(1)+HH(0))/AA(0) 
        DO 33 I=0,N1 
 33     M(I,KR)=(Q(I)-G(I))*DT 
C 
        GOTO(16,17,18,19)KR 
C 
C***************END OF GAUSS ELIMINATION**************** 
C 
 20     IF(K.EQ.KPRINT)  THEN 
        KPRINT=KPRINT+100 
        WRITE(*,101) T 
 101    FORMAT(' ',F6.3) 
        do 102 i=0,400 
 102    write (0,*)  V(i) 
 103    CONTINUE 
        END IF 
C 
 10     CONTINUE 
C 
C*************END OF RK4 LOOP**************************** 
C 
        CLOSE (0) 
        STOP 
        END 
C 
C*************FUNCTION F********************************* 
C 
        FUNCTION F(T1,A1,W1) 
        IF(T1.LE.2.5) THEN 
                F=A1*SIN(W1*T1)*(1.-EXP(-2.*T1*T1)) 
        ELSE 
                F=A1*SIN(W1*T1) 
        END IF 
        RETURN 
        END 

